<?php declare(strict_types = 1);

namespace Mojedpd\Model\Entities;

use Core\Model\Entities\TIdUnsigned;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity]
#[ORM\Table(name: 'mojedpd__order_parcel')]
class MojedpdParcel
{
	use TIdUnsigned;

	#[ORM\ManyToOne(targetEntity: MojedpdOrder::class, inversedBy: 'associatedNumberPackages')]
	#[ORM\JoinColumn(name: 'order_id', referencedColumnName: 'order_id', nullable: false, onDelete: 'CASCADE')]
	protected MojedpdOrder $dpdOrder;

	#[ORM\Column(type: 'string', nullable: true)]
	public ?string $parcelId = null;

	#[ORM\Column(type: 'string', nullable: true)]
	public ?string $parcelNumber = null;

	public function __construct(MojedpdOrder $dpdOrder)
	{
		$this->dpdOrder = $dpdOrder;
	}
}
