<?php declare(strict_types = 1);

namespace Mojedpd\Model\Subscribers;

use Contributte\Translation\Translator;
use Core\Model\Entities\EntityManagerDecorator;
use EshopOrders\Model\Event\EmailEvent;
use EshopOrders\Model\Helpers\OrderHelper;
use Mojedpd\Model\Entities\MojedpdOrder;
use Mojedpd\Model\OrdersExported;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class OrderEmailSubscriber implements EventSubscriberInterface
{
	public function __construct(
		protected EntityManagerDecorator $em,
		protected Translator             $translator,
		protected OrdersExported         $ordersExported
	)
	{
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'eshopOrders.emailChangeOrderStatus' => 'emailChangeOrderStatus',
		];
	}

	public function emailChangeOrderStatus(EmailEvent $event): void
	{
		if (!OrderHelper::canSendTrackingUrl((string) $event->status) || !MojedpdOrder::filterIsDpd((string) $event->order->getSpeditionIdent())) {
			return;
		}

		$exported = $this->ordersExported->getOrders([$event->order->getId()], false)[$event->order->getId()] ?? null;

		if ($exported && $exported->associatedNumberPackages->first()) {
			$parcelNumber                    = $exported->associatedNumberPackages->first()->parcelNumber;
			$event->template->trackingUrl    = $exported->getTrackingUrl((string) $parcelNumber);
			$event->template->trackingNumber = $parcelNumber;
		}
	}
}
