<?php declare(strict_types = 1);

namespace Mojedpd\Model\Subscribers;

use Core\Model\Event\Event;
use EshopOrders\AdminModule\Model\Statuses;
use EshopOrders\Model\Entities\OrderStatus;
use Exception;
use Mojedpd\Model\MojeDpdConfig;
use Mojedpd\Model\OrderApiService;
use Mojedpd\Model\OrdersExported;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Tracy\Debugger;

class OrderSubscriber implements EventSubscriberInterface
{
	public function __construct(
		protected Statuses        $statuses,
		protected OrdersExported  $ordersExported,
		protected OrderApiService $orderApiService,
	)
	{
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'eshopOrders.orders.checkCompleted'        => 'checkCompleted',
			'eshopOrders.orders.checkCompletedMojeDpd' => 'checkCompleted',
		];
	}

	public function checkCompleted(Event $event): void
	{
		if (!MojeDpdConfig::load('trackingApiKey')) {
			return;
		}

		$orders = $this->ordersExported->getOrdersNotCompleted();

		$completed = [];
		foreach ($orders as $id => $uo) {
			if ($this->orderApiService->checkCompleted($uo)) {
				$completed[] = $id;
			}
		}

		foreach ($completed as $id) {
			try {
				$result = $this->statuses->changeStatus([$id], OrderStatus::STATUS_FINISHED);

				if ($result) {
					$this->ordersExported->markAsCompleted([$id]);
				}
			} catch (Exception $e) {
				Debugger::log('Mojedpd error - ' . $e->getMessage(), 'ordersCheckComplete');
				Debugger::log($e);
			}

			$this->ordersExported->em->clear();
		}
	}
}
