document.addEventListener('click', e => {
	if (e.target.dataset.mojedpdChoosePickupPoint !== undefined) {
		e.preventDefault();

		const input  = e.target;
		const target = document.getElementById(input.dataset.target);
		const dataEl = document.getElementById(input.dataset.data);

		let country = input.dataset.country.toUpperCase();
		let iframe  = document.createElement('iframe');

		const url = new URL('https://api.dpd.cz/widget/latest/index.html');
		url.searchParams.set('countries', country);
		url.searchParams.set('enabledCountries', country);
		url.searchParams.set('lang', document.documentElement.lang);

		if (input.dataset.mojedpdDisableBox && input.dataset.mojedpdDisableBox === '1') {
			url.searchParams.set('disableLockers', 'true');
		}

		iframe.setAttribute('src', url.toString());
		iframe.style = `
					position: fixed;
					top: 0;
					left: 0;
					right: 0;
					bottom: 0;
					width: 95vw;
					height: 95vh;
					background: white;
					z-index: 99999;
					margin: auto;
					border: 1px solid black;
				`;
		document.body.appendChild(iframe);

		window.addEventListener('message', (event) => {
			if (event.data.dpdWidget) {
				if (event.data.dpdWidget.message === 'widgetClose') {
					iframe.remove();
					return;
				}

				let data = {
					id               : event.data.dpdWidget.id,
					address          : event.data.dpdWidget.location.address,
					name             : event.data.dpdWidget.name,
					pickupPointResult: event.data.dpdWidget.pickupPointResult
				};

				if (dataEl) {
					dataEl.value = JSON.stringify(data);
				}

				input.value  = event.data.dpdWidget.pickupPointResult;
				target.value = event.data.dpdWidget.id;

				let e = new CustomEvent('pickup-changed', {
					detail: {
						expedition: 'dpd'
					}
				});

				window.dispatchEvent(e);

				iframe.remove();
			}
		}, false);

		return false;
	}
});
