<?php declare(strict_types = 1);

namespace Mojedpd\Model;

use Core\Model\Helpers\BaseService;
use Exception;
use Nette\Caching\Cache;
use Nette\Utils\Json;
use stdClass;
use Tracy\Debugger;

class Branches extends BaseService
{
	protected $cache;
	public const COUNTRY_CZ = '203', COUNTRY_SK = '703', COUNTRY_DE = '276', COUNTRY_PL = '616', COUNTRY_AT = '40';
	public const                                                                                 COUNTRIES  = [
		'cz' => self::COUNTRY_CZ,
		'sk' => self::COUNTRY_SK,
		'de' => self::COUNTRY_DE,
		'pl' => self::COUNTRY_PL,
		'at' => self::COUNTRY_AT,
	];

	public function getBranches(string $country = self::COUNTRY_CZ): array
	{
		try {
			$list = $this->getCache()->load('dpdCountry_' . $country, function(&$dep) use ($country) {
				$dep = [Cache::TAGS => ['dpdBranches'], Cache::EXPIRE => '1 hour'];

				$json = file_get_contents('https://pickup.dpd.cz/api/get-all?country=' . $country);
				$json = Json::decode((string) $json);

				if ($json->status !== 'ok') {
					throw new Exception;
				}

				$list = [];
				foreach ($json->data->items as $row) {
					$list[$row->id] = $row;
				}

				return $list;
			});
		} catch (Exception $e) {
			Debugger::log('MOJEDPD - cannot load branches');

			return [];
		}

		return $list ?: [];
	}

	public function getBranchById(string $id): ?stdClass
	{
		try {
			$branch = $this->getCache()->load('dpdCountry_' . $id, function(&$dep) use ($id) {
				$dep = [Cache::TAGS => ['dpdBranch'], Cache::EXPIRE => '1 hour'];

				$json = file_get_contents('https://pickup.dpd.cz/api/get-parcel-shop-by-id?id=' . $id);
				$json = Json::decode((string) $json);

				if ($json->status !== 'ok') {
					return null;
				}

				return $json->data;
			});
		} catch (Exception $e) {
			Debugger::log('MOJEDPD - cannot load branch ' . $id);

			return null;
		}

		return $branch ?: null;
	}

	public function getCache(): Cache
	{
		if ($this->cache === null) {
			$this->cache = new Cache($this->cacheStorage, 'dpd');
		}

		return $this->cache;
	}

}
