<?php declare(strict_types = 1);

namespace Mojedpd\Model\Entities;

use Core\Model\Entities\TIdUnsigned;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="mojedpd__order_parcel")
 * @ORM\Entity
 */
class MojedpdParcel
{
	use TIdUnsigned;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $parcelId = null;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $parcelNumber = null;

	/**
	 * @ORM\ManyToOne(targetEntity="MojedpdOrder", inversedBy="associatedNumberPackages")
	 * @ORM\JoinColumn(name="order_id", referencedColumnName="order_id", nullable=false, onDelete="CASCADE")
	 */
	protected MojedpdOrder $dpdOrder;

	public function __construct(MojedpdOrder $dpdOrder)
	{
		$this->dpdOrder = $dpdOrder;
	}
}
