<?php declare(strict_types = 1);

namespace Mojedpd\Model\Subscribers;

use Contributte\Translation\Translator;
use EshopOrders\Model\Event\EmailEvent;
use EshopOrders\Model\Helpers\OrderHelper;
use Mojedpd\Model\Entities\MojedpdOrder;
use Mojedpd\Model\OrdersExported;
use Nettrine\ORM\EntityManagerDecorator;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class OrderEmailSubscriber implements EventSubscriberInterface
{
	protected EntityManagerDecorator $em;
	protected Translator             $translator;
	protected OrdersExported         $ordersExported;

	public function __construct(
		EntityManagerDecorator $em,
		Translator             $translator,
		OrdersExported         $ordersExported
	)
	{
		$this->em             = $em;
		$this->translator     = $translator;
		$this->ordersExported = $ordersExported;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'eshopOrders.emailChangeOrderStatus' => 'emailChangeOrderStatus',
		];
	}

	public function emailChangeOrderStatus(EmailEvent $event): void
	{
		if (!OrderHelper::canSendTrackingUrl((string) $event->status) || !MojedpdOrder::filterIsDpd((string) $event->order->getSpeditionIdent())) {
			return;
		}

		$exported = $this->ordersExported->getOrders([$event->order->getId()], false)[$event->order->getId()] ?? null;

		if ($exported && $exported->associatedNumberPackages->first()) {
			$parcelNumber                    = $exported->associatedNumberPackages->first()->parcelNumber;
			$event->template->trackingUrl    = $exported->getTrackingUrl((string) $parcelNumber);
			$event->template->trackingNumber = $parcelNumber;
		}
	}
}
