<?php declare(strict_types=1);

namespace Mojedpd\Model\Utils;

use Mojedpd\Model\Entities\MojedpdOrder;

class Helpers
{
	public static function getServiceIdByServiceName(string $serviceName): int
	{
		switch ($serviceName) {
			case MojedpdOrder::SERVICE_DPD_CLASSIC:
				return MojedpdOrder::SERVICE_ID_DPD_CLASSIC;
			case MojedpdOrder::SERVICE_DPD_PICKUP:
				return MojedpdOrder::SERVICE_ID_DPD_PICKUP;
			case MojedpdOrder::SERVICE_DPD_PRIVATE:
			default:
				return MojedpdOrder::SERVICE_ID_DPD_PRIVATE;
		}
	}
}