<?php declare(strict_types = 1);

namespace MoneyS3\AdminModule\Model\Subscribers;

use Contributte\EventDispatcher\EventSubscriber;
use Core\Model\Event\CreateFormEvent;
use Core\Model\Event\FormSuccessEvent;
use Core\Model\Event\SetFormDataEvent;
use Doctrine\ORM\EntityManager;
use MoneyS3\Model\Entities\PaymentText;
use EshopOrders\AdminModule\Components\Payment\PaymentForm;
use EshopOrders\Model\Entities\Payment;
use Nette\Utils\Json;

class PaymentFormSubscriber implements EventSubscriber
{
	/** @var EntityManager */
	protected $entityManager;
	
	public function __construct(EntityManager $entityManager)
	{
		$this->entityManager = $entityManager;
	}
	
	public static function getSubscribedEvents(): array
	{
		return [
			PaymentForm::class . '::createForm'  => ['createForm', 100],
			PaymentForm::class . '::formSuccess' => ['formSuccess', 100],
			PaymentForm::class . '::setPayment'  => ['setPayment', 100],
		];
	}
	
	public function createForm(CreateFormEvent $event): void
	{
		$form = $event->form;
		
		$form->addGroup('moneyS3.advancedSettings');
		$form->addText('ms3PaymentText', 'moneyS3.paymentText');
	}
	
	public function formSuccess(FormSuccessEvent $event): void
	{
		/** @var Payment $payment */
		$payment = $event->custom['entity'];
		$values  = $event->values;
		
		if ($payment->getId()) {
			/** @var PaymentText $entity */
			$entity = $this->entityManager->getRepository(PaymentText::class)->find($payment->getId());
		}
		if(!$payment->getId() || !$entity) {
			$entity = new PaymentText($payment);
		}
		
		$entity->setText($values->ms3PaymentText);
		
		$this->entityManager->persist($entity);
	}
	
	public function setPayment(SetFormDataEvent $event): void
	{
		/** @var PaymentText $entity */
		$entity = $this->entityManager->getRepository(PaymentText::class)->find($event->entity->getId());
		
		if ($entity) {
			$event->form->setDefaults([
				'ms3PaymentText'   => $entity->getText(),
			]);
		}
	}
}
