<?php declare(strict_types = 1);

namespace MoneyS3\FrontModule\Presenters;

use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Orders;
use MoneyS3\Model\OrdersExported;
use MoneyS3\Model\OrderXmlService;
use Nette\Application\Responses\TextResponse;

class ExportPresenter extends BasePresenter
{
	/** @var Orders */
	protected $ordersService;

	/** @var OrderXmlService */
	protected $orderXmlService;
	
	/** @var OrdersExported */
	protected $ordersExported;
	
	public function __construct(Orders $orders, OrderXmlService $orderXml, OrdersExported $ordersExported)
	{
		$this->ordersService   = $orders;
		$this->orderXmlService = $orderXml;
		$this->ordersExported = $ordersExported;
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */
	
	public function actionExportOrders()
	{
		set_time_limit(600);
		
		$orders = $this->ordersExported->getOrdersNotExported();
		foreach ($orders as $order) {
			if($this->exportOrder($order)) {
				$this->ordersExported->markAsDone($order); //vytvori entitu a ulozi do DB
			} else {
				//TODO kam zalogovat chybu, pripadne odeslat emailem nebo vypsat do adminu?
			}
		}
		
		$response = new TextResponse('OK');
		$this->sendResponse($response);
	}
	
	/**
	 * @param $order Order
	 * @return bool
	 */
	public function exportOrder($order)
	{
		if(!$order) {
			return false;
		}
		
		$orders_file = WWW_DIR . "/uploads/money-s3/orders/op-{$order->getId()}.xml";
		
		$dom = $this->orderXmlService->generateOrderXml($order);
		
		$ret = $dom->save($orders_file);
		if(!$ret) {
			return false;
		}
		
		return true;
	}

	/*******************************************************************************************************************
	 * ============================== Helper Export functions
	 */
	
	/*******************************************************************************************************************
	 * ============================== Components
	 */

}
