<?php declare(strict_types=1);

namespace MoneyS3\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;
use Nette\Utils\DateTime;
use EshopOrders\Model\Entities\Order;

/**
 * @ORM\Table(name="moneys3__order_exported")
 * @ORM\Entity
 */
class OrderExported
{
	use Identifier;
	use MagicAccessors;
	
	/**
	 * @var Order
	 * @ORM\OneToOne(targetEntity="\EshopOrders\Model\Entities\Order")
	 * @ORM\JoinColumn(name="order_id", referencedColumnName="id")
	 */
	protected $order;
	
	/**
	 * @var DateTime
	 * @ORM\Column(name="exported", type="datetime", nullable=false)
	 */
	protected $exported;
	
	/**
	 * OrderExported constructor.
	 * @param Order $order
	 */
	public function __construct($order)
	{
		$this->order = $order;
	}
	
	public function getOrder()
	{
		return $this->order;
	}
	
	public function getExported()
	{
		return $this->exported;
	}
	
	public function setExported($exported): OrderExported
	{
		$this->exported = $exported;
		return $this;
	}
	
	
}
