<?php declare(strict_types = 1);

namespace MoneyS3\Model\Navigation;

use Core\Components\Navigation\DaoNavigationItem;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use Navigations\Model\Entities\Navigation;
use Navigations\Model\Providers\INavigationItem;
use Nette\Utils\ArrayHash;

class ExportXml extends BaseNavigation implements INavigationItem
{
	protected $title = 'export';
	
	protected $presenter = 'MoneyS3:Front:Export';
	protected $actionOrder = 'exportOrders';
	
	protected const URL_ORDER = 'export-orders';

	public function __construct()
	{
	}

	/**
	 * @return BaseContainer
	 */
	public function getFormContainer()
	{
		$container = new BaseContainer();

		return $container;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{

	}

	/*******************************************************************************************************************
	 * ===========================  Route
	 */

	public function presenterActionCheck($presenter, $action)
	{
		if($this->presenter == $presenter && $this->actionOrder == $action) {
			return 1;
		}
		return false;
	}

	/**
	 * @param Navigation $navigation
	 * @param array      $urlParams
	 *
	 * @return array|mixed
	 */
	public function routerIn($navigation, $urlParams = [])
	{
		$return = [
			'presenter' => $this->presenter,
			'action'    => null,
			'id'        => null,
		];
		
		if (isset($urlParams['path'])) {
			
			$params = explode('/', $urlParams['path']);
			$lastSegment = array_pop($params);
			
			if ($lastSegment == self::URL_ORDER) {
				$return = [
					'presenter' => $this->presenter,
					'action'    => $this->actionOrder,
					'id'        => null,
				];
			}
		}
		
		return $return;
	}

	public function routerOut(DaoNavigationItem $navigation, &$urlParams):?string
	{
		$urlParts = [];
		if (!$navigation->isHomepage)
			$urlParts[] = $navigation->alias;
		
		if($urlParams['action'] == $this->actionOrder) {
			$urlParts[] = self::URL_ORDER;
		}
		
		$url = '/' . implode('/', $urlParts);
		return $url;
	}
}
