<?php declare(strict_types = 1);

namespace MoneyS3\Model;

use Core\Model\Helpers\BaseEntityService;
use MoneyS3\Model\Entities\PaymentText;

/**
 * class PaymentTexts
 * @package MoneyS3\Model
 * 
 * @method PaymentText|object|null getReference($id)
 * @method PaymentText|null get($id)
 */
class PaymentTexts extends BaseEntityService
{
	
	protected $entityClass = PaymentText::class;
	
	public function __construct()
	{
	}
	
	public function getAll()
	{
		$paymentsQuery = $this->getEr()->createQueryBuilder('pt');
		$res = $paymentsQuery->getQuery()->getResult();
		
		//workaround - indexace podle ciziho klice
		$paymentTexts = [];
		foreach ($res as $payText) {
			$paymentTexts[$payText->getPayment()->getId()] = $payText;
		}
		
		return $paymentTexts;
	}
}
