<?php declare(strict_types=1);

namespace MoneyS3\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;
use EshopOrders\Model\Entities\Payment;

/**
 * @ORM\Table(name="moneys3__payment_text")
 * @ORM\Entity
 */
class PaymentText
{
	use MagicAccessors;
	
	/**
	 * @var Payment
	 * @ORM\Id
	 * @ORM\OneToOne(targetEntity="\EshopOrders\Model\Entities\Payment")
	 * @ORM\JoinColumn(name="payment_id", referencedColumnName="id")
	 */
	protected $payment;
	
	/**
	 * @var string
	 * @ORM\Column(name="name", type="string")
	 */
	protected $text;
	
	/**
	 * PaymentText constructor.
	 * @param Payment $payment
	 */
	public function __construct($payment)
	{
		$this->payment = $payment;
	}
	
	public function getPayment()
	{
		return $this->payment;
	}
	
	public function getText()
	{
		return $this->text;
	}
	
	public function setText($text): PaymentText
	{
		$this->text = $text;
		return $this;
	}
	
	
}
