<?php declare(strict_types = 1);

namespace MoneyS3\CronModule\Presenters;

use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Orders;
use MoneyS3\Model\OrdersExported;
use MoneyS3\Model\OrderXmlService;
use Nette\Application\Responses\TextResponse;
use Nette\Utils\FileSystem;
use Tracy\Debugger;

class ExportPresenter extends BasePresenter
{
	/** @var Orders */
	protected $ordersService;

	/** @var OrderXmlService */
	protected $orderXmlService;

	/** @var OrdersExported */
	protected $ordersExported;

	public function __construct(Orders $orders, OrderXmlService $orderXml, OrdersExported $ordersExported)
	{
		$this->ordersService   = $orders;
		$this->orderXmlService = $orderXml;
		$this->ordersExported  = $ordersExported;
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionExportOrders(): void
	{
		set_time_limit(600);

		$orders = $this->ordersExported->getOrdersNotExported();
		foreach ($orders as $order) {
			if ($this->exportOrder($order)) {
				$this->ordersExported->markAsDone($order); //vytvori entitu a ulozi do DB
			} else {
				Debugger::log("Failed export order id '{$order->getId()}'", 'moneyS3Export');
			}
		}

		$this->sendResponse(new TextResponse('OK'));
	}

	/**
	 * @param $order Order
	 *
	 * @return bool
	 */
	public function exportOrder($order): bool
	{
		if (!$order) {
			return false;
		}

		$dir = ROOT_DIR . '/../money_import/import';
		FileSystem::createDir($dir);
		$orders_file = $dir . "/op-{$order->getId()}.xml";

		$dom = $this->orderXmlService->generateOrderXml($order);

		$ret = $dom->save($orders_file);
		if (!$ret) {
			return false;
		}

		return true;
	}
}
