<?php declare(strict_types = 1);

namespace MoneyS3\DI;

use Core\DI\CompilerExtension;
use Nette;

class MoneyS3Extension extends CompilerExtension
{
	public function loadConfiguration()
	{
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));
		
		Nette\DI\Compiler::loadDefinitions(
			$this->getContainerBuilder(),
			$this->loadFromFile(__DIR__ . '/services.neon')
		);
	}
	
	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['MoneyS3' => 'MoneyS3\*Module\Presenters\*Presenter']);
	}

	public function afterCompile(Nette\PhpGenerator\ClassType $class)
	{
		parent::afterCompile($class);
		$init    = $class->methods["initialize"];
		$builder = $this->getContainerBuilder();

		$init->addBody('MoneyS3\Model\MoneyS3Config::setParams(?);', [$builder->parameters['moneyS3']]);
	}
}
