<?php declare(strict_types = 1);

namespace MoneyS3\AdminModule\Model\Subscribers;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Core\Model\Event\CreateFormEvent;
use Core\Model\Event\FormSuccessEvent;
use Core\Model\Event\SetFormDataEvent;
use Core\Model\Entities\EntityManagerDecorator;
use MoneyS3\Model\Entities\PaymentText;
use EshopOrders\AdminModule\Components\Payment\PaymentForm;
use EshopOrders\Model\Entities\Payment;

class PaymentFormSubscriber implements EventSubscriberInterface
{
	protected EntityManagerDecorator $entityManager;

	public function __construct(EntityManagerDecorator $entityManager)
	{
		$this->entityManager = $entityManager;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			PaymentForm::class . '::createForm'  => ['createForm', 100],
			PaymentForm::class . '::formSuccess' => ['formSuccess', 100],
			PaymentForm::class . '::setPayment'  => ['setPayment', 100],
		];
	}

	public function createForm(CreateFormEvent $event): void
	{
		$form = $event->form;

		$form->addGroup('moneyS3.advancedSettings');
		$form->addText('ms3PaymentText', 'moneyS3.paymentText');
	}

	public function formSuccess(FormSuccessEvent $event): void
	{
		/** @var Payment $payment */
		$payment = $event->custom['entity'];
		$values  = $event->values;
		/** @var PaymentText $entity|null */
		$entity = null;

		if ($payment->getId()) {
			$entity = $this->entityManager->getRepository(PaymentText::class)->find($payment->getId());
		}
		if (!$payment->getId() || $entity === null) {
			$entity = new PaymentText($payment);
		}

		$entity->setText($values->ms3PaymentText);

		$this->entityManager->persist($entity);
	}

	public function setPayment(SetFormDataEvent $event): void
	{
		/** @var Payment $payment */
		$payment = $event->entity;

		/** @var PaymentText|null $entity */
		$entity = $this->entityManager->getRepository(PaymentText::class)->find($payment->getId());

		if ($entity) {
			$event->form->setDefaults([
				'ms3PaymentText' => $entity->getText(),
			]);
		}
	}
}
