<?php declare(strict_types = 1);

namespace MoneyS3\Model\Entities;

use Core\Model\Entities\TId;
use DateTimeInterface;
use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\DateTime;
use EshopOrders\Model\Entities\Order;

/**
 * @ORM\Table(name="moneys3__order_exported")
 * @ORM\Entity
 */
class OrderExported
{
	use TId;

	/**
	 * @ORM\OneToOne(targetEntity="\EshopOrders\Model\Entities\Order")
	 * @ORM\JoinColumn(name="order_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected ?Order $order = null;

	/**
	 * @var DateTime
	 * @ORM\Column(type="datetime", nullable=false)
	 */
	protected $exported;

	public function __construct(?Order $order)
	{
		$this->order = $order;
	}

	public function getOrder(): ?Order
	{
		return $this->order;
	}

	/**
	 * @return DateTime
	 */
	public function getExported()
	{
		return $this->exported;
	}

	/**
	 * @param DateTime $exported
	 * @return $this
	 */
	public function setExported($exported): OrderExported
	{
		$this->exported = $exported;

		return $this;
	}
}
