<?php declare(strict_types = 1);

namespace MoneyS3\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use EshopOrders\Model\Entities\Payment;

/**
 * @ORM\Table(name="moneys3__payment_text")
 * @ORM\Entity
 */
class PaymentText
{
	/**
	 * @ORM\Id
	 * @ORM\OneToOne(targetEntity="\EshopOrders\Model\Entities\Payment")
	 * @ORM\JoinColumn(name="payment_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected Payment $payment;

	/**
	 * @ORM\Column(name="name", type="string")
	 */
	protected string $text;

	public function __construct(Payment $payment)
	{
		$this->payment = $payment;
	}

	public function getPayment(): Payment
	{
		return $this->payment;
	}

	public function getText(): string
	{
		return $this->text;
	}

	public function setText(string $text): PaymentText
	{
		$this->text = $text;

		return $this;
	}
}
