<?php declare(strict_types = 1);

namespace MoneyS3\Model;

use Core\Model\Helpers\BaseEntityService;
use EshopOrders\Model\Entities\Order;
use MoneyS3\Model\Entities\OrderExported;
use Nette\Utils\DateTime;

/**
 * @method OrderExported|null getReference($id)
 * @method OrderExported[] getAll()
 * @method OrderExported|null get($id)
 */
class OrdersExported extends BaseEntityService
{
	protected $entityClass = OrderExported::class;

	/**
	 * Vytvori entitu OrderExported pro danou objednavku a cas "ted"
	 */
	public function markAsDone(Order $order): void
	{
		/** @var OrderExported|null $orderExported */
		$orderExported = $this->getEr()->findOneBy(['order' => $order->getId()]);

		if (!$orderExported) {
			$orderExported = new OrderExported($order);
		}

		$orderExported->setExported(new DateTime);
		$this->em->persist($orderExported);
		$this->em->flush();
	}

	/**
	 * Vrati seznam objednavek, ktere jeste nebyly exportovany do XML
	 *
	 * @return Order[]
	 */
	public function getOrdersNotExported(): array
	{
		$expr = $this->em->getExpressionBuilder();

		//kdy byla objednavka zpracovana
		$sub = $this->getEr()->createQueryBuilder('oe')
			->where('oe.order = o.id');

		//objednavky ktere nejsou v seznamu zpracovanych objednavek
		$ordersQuery = $this->em->getRepository(Order::class)->createQueryBuilder('o', 'o.id')
			->where($expr->not($expr->exists($sub->getDQL())))
			->orderBy('o.id');


		/* alternativa - ziskat paymentText rovnou zaroven s objednavkou
		$ordersQuery = $this->em->getRepository(Order::class)->createQueryBuilder('o', 'o.id')
			->addSelect('ptext.text')
			->leftJoin('o.payment', 'op')
			->leftJoin('op.payment', 'p')
			->leftJoin(\MoneyS3\Model\Entities\PaymentText::class, 'ptext', 'WITH', 'ptext.payment = p.id')
			->where('ptext.id IS NULL')
			->orderBy('o.id')
			->groupBy('o.id'); */

		return $ordersQuery->getQuery()->getResult();
	}
}
