<?php declare(strict_types = 1);

namespace MoneyS3\Model;

use Core\Model\Helpers\BaseEntityService;
use MoneyS3\Model\Entities\PaymentText;

/**
 * @method PaymentText|null getReference($id)
 * @method PaymentText|null get($id)
 */
class PaymentTexts extends BaseEntityService
{
	protected $entityClass = PaymentText::class;

	/**
	 * @return PaymentText[]
	 */
	public function getAll(): array
	{
		$paymentsQuery = $this->getEr()->createQueryBuilder('pt');
		$res = $paymentsQuery->getQuery()->getResult();
		
		//workaround - indexace podle ciziho klice
		$paymentTexts = [];
		foreach ($res as $payText) {
			$paymentTexts[$payText->getPayment()->getId()] = $payText;
		}
		
		return $paymentTexts;
	}
}
