<?php declare(strict_types = 1);

namespace MultihubDropShip\AdminModule\Components\Categories;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use EshopCatalog\AdminModule\Model\Categories;
use MultihubDropShip\AdminModule\Model\AllowedCategories;
use MultihubDropShip\Model\Entities\Client;
use Nette\Utils\ArrayHash;

class AllowedCategoriesForm extends BaseControl
{
	protected Client            $client;
	protected Categories        $categories;
	protected AllowedCategories $allowedCategories;

	public function __construct(
		Client            $client,
		Categories        $categories,
		AllowedCategories $allowedCategories
	)
	{
		$this->client            = $client;
		$this->categories        = $categories;
		$this->allowedCategories = $allowedCategories;
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm(): BaseForm
	{
		$form = $this->createForm();
		$form->setShowLangSwitcher(false);
		$form->setAjax();

		$form->addBool('sendAll', 'multihubDropShip.allowedCategories.sendAll')
			->setDefaultValue($this->client->sendAll);

		$form->addCheckboxNestedList(
			'categories',
			'multihubDropShip.allowedCategories.allowedCategories',
			$this->categories->getFlatTree($this->client->siteIdent)
		)
			->setDefaultValue($this->client->allowedCategories->getKeys());

		$form->onSuccess[] = [$this, 'formSuccess'];

		$form->addSubmit('save', 'default.save');

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values): void
	{
		$result = $this->allowedCategories->updateAllowedCategories(
			$this->client,
			$values->categories,
			(int) $values->sendAll
		);

		if ($result) {
			$this->presenter->flashMessageSuccess('default.saved');
		} else {
			$this->presenter->flashMessageDanger('default.error');
		}

		$this->presenter->redrawControl('flashes');
	}
}
