<?php declare(strict_types = 1);

namespace MultihubDropShip\AdminModule\Presenters;

use MultihubDropShip\AdminModule\Components\Categories\AllowedCategoriesForm;
use MultihubDropShip\AdminModule\Components\Categories\IAllowedCategoriesFormFactory;
use MultihubDropShip\AdminModule\Components\Clients\ClientForm;
use MultihubDropShip\AdminModule\Components\Clients\IClientFormFactory;
use MultihubDropShip\Model\Clients;
use MultihubDropShip\Model\Entities\Client;
use MultihubDropShip\Model\Sync\SyncProducts;
use Nette\Application\UI\Multiplier;

class DefaultPresenter extends BasePresenter
{
	//	protected AlzaClients  $alzaClients;
	//	protected SyncProducts $syncProducts;
	//	protected SyncDelivery $syncDelivery;
	//	protected SyncOrder    $syncOrder;
	//	protected TestApi      $testApi;
	//
	//	public function __construct(
	//		AlzaClients  $alzaClients,
	//		SyncProducts $syncProducts,
	//		SyncDelivery $syncDelivery,
	//		SyncOrder    $syncOrder,
	//		TestApi      $testApi
	//	)
	//	{
	//		parent::__construct();
	//		$this->alzaClients  = $alzaClients;
	//		$this->syncProducts = $syncProducts;
	//		$this->syncDelivery = $syncDelivery;
	//		$this->syncOrder    = $syncOrder;
	//		$this->testApi      = $testApi;
	//	}

	protected Clients $clients;
	protected SyncProducts $syncProducts;

	public function __construct(
		Clients $clients,
	SyncProducts $syncProducts
	)
	{
		parent::__construct();
		$this->clients = $clients;
		$this->syncProducts = $syncProducts;
	}

	protected function startup(): void
	{
		parent::startup();
		$this->setHeader('multihubDropShip.menu.dropShip', 'fas fa-map-signs');
	}

	/*******************************************************************************************************************
	 * ======================== Handle
	 */

	//	public function handleUpdateAll(): void
	//	{
	//		$this->syncProducts->updateAll();
	//		$this->redrawControl('flashes');
	//	}
	//
	//	public function handleTestInsertOrder(): void
	//	{
	//		$products = explode(' ', (string) $this->getHttpRequest()->getPost('products'));
	//		if (is_array($products)) {
	//			$this->testApi->insertOrder($this->alzaClients->getDefaultClient(), $products);
	//		}
	//	}
	//
	//	public function handleTestCancelOrder(): void
	//	{
	//		$this->testApi->cancelOrder($this->alzaClients->getDefaultClient());
	//	}
	//
	//	public function handleTestConfirmOrder(): void
	//	{
	//		$this->testApi->confirmOrder($this->alzaClients->getDefaultClient());
	//	}
	//
	/*******************************************************************************************************************
	 * ======================== Action
	 */

	public function actionDefault(): void
	{
	}

	/*******************************************************************************************************************
	 * ======================== Action
	 */

	public function renderDefault(): void
	{
		$this->template->clients = $this->em->getRepository(Client::class)->findAll();
	}

	public function actionUpdateProducts(int $clientId):void {
		var_dump($clientId);
		$this->syncProducts->updateAll($clientId);
	}

	//
	//	public function actionDeliveryReject(int $id): void
	//	{
	//		if ($this->syncDelivery->rejectDelivery($this->alzaClients->getDefaultClient(), $id)) {
	//			$this->flashMessageSuccess('alza.orderForm.deliveryRejected');
	//		} else {
	//			$this->flashMessageDanger('alza.orderForm.deliveryRejectFailed');
	//		}
	//		$this->redrawControl('flashes');
	//	}
	//
	//	public function actionCancelOrder(int $id): void
	//	{
	//		try {
	//			if ($this->syncDelivery->cancelDelivery($this->alzaClients->getDefaultClient(), $id)) {
	//				$this->flashMessageSuccess('alza.orderForm.orderCancelled');
	//			} else {
	//				$this->flashMessageDanger('alza.orderForm.orderCancelFailed');
	//			}
	//		} catch (\Exception$e) {
	//			MultihubDropShipLogger::log($e);
	//			$this->flashMessageDanger('alza.orderForm.orderCancelFailed');
	//		}
	//
	//		$this->redrawControl('flashes');
	//	}
	//
	/*******************************************************************************************************************
	 * ======================== Component
	 */

	protected function createComponentClientForm(IClientFormFactory $factory): Multiplier
	{
		return new Multiplier(function(string $id) use ($factory): ClientForm {
			/** @var Client|null $client */
			$client = $this->em->getRepository(Client::class)->find($id);

			if (!$client) {
				throw new \Exception('Client not found');
			}

			return $factory->create($client);
		});
	}

	protected function createComponentAllowedCategoriesForm(IAllowedCategoriesFormFactory $factory): Multiplier
	{
		return new Multiplier(function(string $id) use ($factory): AllowedCategoriesForm {
			/** @var Client|null $client */
			$client = $this->em->getRepository(Client::class)->find($id);

			if (!$client) {
				throw new \Exception('Client not found');
			}

			return $factory->create($client);
		});
	}

	//	protected function createComponentSettingsForm(ISettingsFormFactory $factory): Multiplier
	//	{
	//		return new Multiplier(function($country) use ($factory): SettingsForm {
	//			$control          = $factory->create('');
	//			$control->country = $country;
	//
	//			return $control;
	//		});
	//	}
	//
	//	protected function createComponentCategories(ICategoriesGridFactory $factory): CategoriesGrid
	//	{
	//		return $factory->create();
	//	}

}
