<?php declare(strict_types = 1);

namespace MultihubDropShip\Console;

use Core\Model\Event\Event;
use Core\Model\Event\EventDispatcher;
use Doctrine;
use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use Exception;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

class CheckCompleted extends AbstractCommand
{
	/** @var EventDispatcher|null @inject */
	public ?EventDispatcher $eventDispatcher = null;

	protected function configure(): void
	{
		$this->setName('multihub-drop-ship:chech-completed')
			->setDescription('Check orders');
	}

	protected function executeSchemaCommand(InputInterface $input, OutputInterface $output, Doctrine\ORM\Tools\SchemaTool $schemaTool, array $metadatas, SymfonyStyle $ui): int
	{
		$output->writeln('<fg=white;bg=#007bff>Multihub - Check completed</>');
		try {
			if (!$this->eventDispatcher) {
				throw new Exception('Event dispatcher not found');
			}

			$this->eventDispatcher->dispatch(new Event(), 'MultihubDropShip.orders.checkCompleted');

			$output->writeLn('<info>[OK] - orders checked</info>');
		} catch (Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}
}
