<?php declare(strict_types = 1);

namespace MultihubDropShip\Console;

use Doctrine;
use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use MultihubDropShip\Model\Sync\SyncCategories;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;
use Tracy\Debugger;

class UpdateCategories extends AbstractCommand
{
	protected SyncCategories $syncCategories;

	public function __construct(
		SyncCategories $syncProducts,
		?string        $name = null
	)
	{
		parent::__construct($name);
		$this->syncCategories = $syncProducts;
	}

	protected function configure(): void
	{
		$this->setName('multihub-drop-ship:update-all-categories')
			->addOption('clientId', null, InputOption::VALUE_REQUIRED)
			->setDescription('Update all categories');
	}

	protected function executeSchemaCommand(InputInterface $input, OutputInterface $output, Doctrine\ORM\Tools\SchemaTool $schemaTool, array $metadatas, SymfonyStyle $ui): int
	{
		set_time_limit(60 * 30);

		$output->writeln('Multihub DropShip - update all categories');

		try {
			Debugger::dispatch();
			ini_set('memory_limit', '2G');

			$this->syncCategories->updateAll((int) $input->getOption('clientId'));

			$output->writeLn('<info>[OK] - categories updated</info>');

			return 0;
		} catch (\Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}
}
