<?php declare(strict_types = 1);

namespace MultihubDropShip\DI;

use Core\DI\CompilerExtension;
use Nette;

class MultihubDropShipExtension extends CompilerExtension
{

	public function loadConfiguration()
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['MultihubDropShip' => 'MultihubDropShip\*Module\Presenters\*Presenter']);
	}

	public function afterCompile(Nette\PhpGenerator\ClassType $class)
	{
		parent::afterCompile($class);
		$init    = $class->methods["initialize"];
		$builder = $this->getContainerBuilder();

		$init->addBody('MultihubDropShip\Model\MultihubDropShipConfig::setParams(?);', [$builder->parameters['multihubDropShip']]);
	}
}
