<?php declare(strict_types = 1);

namespace MultihubDropShip\FrontModule\Model;

use Core\Model\Entities\EntityManagerDecorator;
use MultihubDropShip\Model\CacheService;
use Nette\Caching\Cache;
use Nette\Utils\Json;

class ReviewsService
{
	protected EntityManagerDecorator $em;
	protected CacheService           $cacheService;

	public function __construct(
		EntityManagerDecorator $em,
		CacheService           $cacheService
	)
	{
		$this->em           = $em;
		$this->cacheService = $cacheService;
	}

	public function getRating(int $id): ?array
	{
		return $this->cacheService->getCache()->load($this->cacheService->getRatingKey($id), function(&$dep) use ($id) {
			$dep = [
				Cache::EXPIRE => '1 week',
			];

			$result = [];
			$data   = $this->em->getConnection()->fetchAssociative("SELECT allegro_rating FROM multihub_drop_ship__client WHERE id = ? LIMIT 1", [$id]);

			if (isset($data['allegro_rating'])) {
				try {
					$tmp = Json::decode((string) $data['allegro_rating'], Json::FORCE_ARRAY);;
					$result['allegro'] = [
						'rating'        => (float) $tmp['percentage'],
						'reviews_count' => (int) $tmp['count'],
					];
				} catch (\Exception $e) {
				}
			}

			return $result;
		}) ?: null;
	}
}
