<?php declare(strict_types = 1);

namespace MultihubDropShip\Model\Api;

use Core\Model\Helpers\Strings;
use Exception;
use MultihubDropShip\Model\Dao\Client;
use MultihubDropShip\Model\MultihubDropShipLogger;
use Nette\Utils\Json;
use Nette\Utils\JsonException;

abstract class BaseApi
{
	/**
	 * @return mixed|null
	 * @throws JsonException
	 */
	public function sendRequest(Client $client, string $method, string $url = '', array $args = [], array $data = [])
	{
		$ch = curl_init();

		if ($url && !Strings::startsWith($url, '/')) {
			$url = '/' . $url;
		}

		$curlUrl = $client->getEndPoint() . $url . '?_access_token=' . $client->getApiKey();

		foreach ($args as $k => $v) {
			$curlUrl .= '&' . $k . '=' . $v;
		}

		MultihubDropShipLogger::log($method . ' - ' . $curlUrl);
		MultihubDropShipLogger::log(Json::encode($data));

		curl_setopt($ch, CURLOPT_URL, $curlUrl);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_HEADER, false);
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
		curl_setopt($ch, CURLOPT_POSTFIELDS, Json::encode($data));
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
		curl_setopt($ch, CURLOPT_TIMEOUT, 0);

		$headers = [
			"Content-Type: application/json",
		];

		if ($client->getSecretToken()) {
			$headers['Authorization'] = 'Bearer ' . $client->getSecretToken();
		}

		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$response = curl_exec($ch);
		$error    = curl_error($ch);

		curl_close($ch);

		if ($error) {
			MultihubDropShipLogger::log($error);
		} else if ($response) {
			try {
				$json = Json::decode((string) $response, Json::FORCE_ARRAY);
			} catch (Exception $e) {
				MultihubDropShipLogger::log("RESPONSE: " . $response);

				return null;
			}

			if ($json['status'] === 'error') {
				MultihubDropShipLogger::log('RESPONSE ERROR');
				MultihubDropShipLogger::log(Json::encode($json));
				MultihubDropShipLogger::log(sprintf(
					'Request %s %s',
					$method,
					$curlUrl
				));

				//				LogNotifier::toDevelopers(sprintf(
				//					'Request %s %s\r\n\r\nError %s %s\r\n%s',
				//					$method,
				//					$curlUrl,
				//					$json['code'],
				//					$json['message'],
				//					Json::encode($json)
				//				),
				//					'Multihub DropShip error'
				//				);

				return null;
			}

			MultihubDropShipLogger::log('RESPONSE RESULT');
			MultihubDropShipLogger::log(Json::encode($json));

			return $json;
		}

		return null;
	}
}
