<?php declare(strict_types = 1);

namespace MultihubDropShip\Model\Entities;

use Core\Model\Entities\TIdUnsigned;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Entities\Seller;

/**
 * @ORM\Entity
 * @ORM\Table(name="multihub_drop_ship__client")
 */
class Client
{
	use TIdUnsigned;

	/** @ORM\Column(type="string", length=255, nullable=false, unique=true) */
	public string $name;

	/** @ORM\Column(type="string", length=255, nullable=true) */
	public ?string $apiKey = null;

	/** @ORM\Column(type="string", length=255, nullable=true) */
	public ?string $secretToken = null;

	/** @ORM\Column(type="smallint", length=1, nullable=false, options={"default": 0, "unsigned": true}) */
	public int $isTest = 0;

	/** @ORM\Column(type="smallint", length=1, nullable=false, options={"default": 0, "unsigned": true}) */
	public int $isActive = 0;

	/** @ORM\Column(type="smallint", length=1, nullable=false, options={"default": 0, "unsigned": true}) */
	public int $sendAll = 0;

	/** @ORM\Column(type="smallint", length=1, nullable=false, options={"default": 0, "unsigned": true}) */
	public int $addCanAddToCartProds = 0;

	/**
	 * @var Collection<int, AllowedCategory>
	 * @ORM\OneToMany(targetEntity="AllowedCategory", mappedBy="client", indexBy="category_id")
	 */
	public Collection $allowedCategories;

	/**
	 * Allegro
	 * @ORM\ManyToOne(targetEntity="EshopCatalog\Model\Entities\Seller")
	 * @ORM\JoinColumn(referencedColumnName="id", onDelete="SET NULL")
	 */
	public ?Seller $seller = null;

	/**
	 * Kaufland
	 * @ORM\ManyToOne(targetEntity="EshopCatalog\Model\Entities\Seller")
	 * @ORM\JoinColumn(referencedColumnName="id", onDelete="SET NULL")
	 */
	public ?Seller $sellerKaufland = null;

	/**
	 * @ORM\Column(type="string", length=255, nullable=false, options={"default": ""})
	 */
	public string $imageBaseUrl = '';

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	public ?string $siteIdent = null;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	public ?string $lang = null;

	/**
	 * @ORM\Column(type="json", nullable=true)
	 */
	public ?string $allegroRating = null;

	public function __construct(string $name)
	{
		$this->name              = $name;
		$this->allowedCategories = new ArrayCollection();
	}
}
