<?php declare(strict_types = 1);

namespace MultihubDropShip\Model;

use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\Helpers\Strings;
use DynamicModule\FrontModule\Model\Repository\IGroupsFactory;
use EshopCatalog\Model\Config;
use MultihubDropShip\Model\Dao\Client;
use Nette\Utils\Json;

class EshopCategories
{
	protected EntityManagerDecorator $em;
	protected IGroupsFactory         $groupsFactory;

	protected array $cCategories = [];

	public static array $dynamicModuleMembers = [];
	public static array $dynamicModuleGroups  = [];

	public function __construct(
		EntityManagerDecorator $em,
		IGroupsFactory         $groupsFactory
	)
	{
		$this->em            = $em;
		$this->groupsFactory = $groupsFactory;
	}

	public function getCategories(Client $client): array
	{
		if ($client->sendAll) {
			$key                   = $client->getId() . '_all';
			$dynamicModuleGroupIds = [];

			if (!array_key_exists($key, $this->cCategories)) {
				$catRootId = $this->em->getConnection()->fetchAssociative("SELECT c.id as id, c.lft as lft, c.rgt as rgt, c.tree_root as root 
					FROM eshop_catalog__category c 			
					INNER JOIN eshop_catalog__category_texts ct ON ct.id = c.id AND ct.alias = ?
					WHERE c.lvl = 0 AND c.id = c.tree_root LIMIT 1", [
					$client->siteIdent,
				]);

				$publishedByLang = Config::load('category.publishedByLang');

				$categoriesIds = [];
				if ($catRootId) {
					foreach ($this->em->getConnection()->executeQuery("SELECT c.id, c.attrs 
						FROM eshop_catalog__category c" .
						($publishedByLang ? " INNER JOIN eshop_catalog__category_texts ct ON ct.id = c.id AND ct.is_published = 1 AND ct.lang = '" . $client->lang . "'" : '') .
						" WHERE c.lft >= :lft AND c.rgt <= :rgt AND c.tree_root = :root" .
						(!$publishedByLang ? ' AND c.is_published = 1' : ''), [
						'lft'  => $catRootId['lft'],
						'rgt'  => $catRootId['rgt'],
						'root' => $catRootId['root'],
					])->iterateAssociative() as $row) {
						/** @var array $row */
						if ($row['attrs']) {
							try {
								$attrs = Strings::startsWith('{', $row['attrs'])
									? Json::decode($row['attrs'], Json::FORCE_ARRAY)
									: unserialize($row['attrs'], ['allowed_classes' => true]);

								if (!empty($attrs)) {
									foreach ($attrs['topDynamicModuleInCategory'] ?? [] as $v) {
										$dynamicModuleGroupIds[$row['id']][] = (int) $v;
									}
									foreach ($attrs['bottomDynamicModuleInCategory'] ?? [] as $v) {
										$dynamicModuleGroupIds[$row['id']][] = (int) $v;
									}
								}
							} catch (\Exception $e) {
							}
						}

						$categoriesIds[] = $row['id'];
					}
				}

				$this->cCategories[$key] = $categoriesIds;
				$categoriesIds           = null;
			}

			if (!empty($dynamicModuleGroupIds)) {
				$dynamicModuleGroups = $this->groupsFactory->create('dynamic');

				foreach ($dynamicModuleGroupIds as $catId => $groupsIds) {
					self::$dynamicModuleGroups[$catId] = $groupsIds;

					foreach ($groupsIds as $groupId) {
						foreach ($dynamicModuleGroups->getByIds([$groupId], $client->lang) as $dynamicModuleGroup) {
							foreach ($dynamicModuleGroup->getMembers() as $member) {
								$this->cCategories[$key][] = 'V_' . $member->getId();

								self::$dynamicModuleMembers[$catId][$member->getId()] = $member->getId();
							}
						}
					}
				}
			}

			return $this->cCategories[$key];
		}

		return $client->allowedCategoriesIds;
	}
}
