<?php declare(strict_types = 1);

namespace MultihubDropShip\AdminModule\Components\Clients;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use EshopCatalog\AdminModule\Model\Sellers;
use EshopCatalog\Model\Entities\Seller;
use Exception;
use MultihubDropShip\Model\Entities\Client;
use Nette\Utils\ArrayHash;

class ClientForm extends BaseControl
{
	public function __construct(
		protected Client  $client,
		protected Sellers $sellers,
	)
	{
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	public function createComponentForm(): BaseForm
	{
		$form = $this->createForm();
		$form->setShowLangSwitcher(false);
		$form->setAjax();

		$form->addBool('isActive', 'multihubDropShip.client.isActive')
			->setDefaultValue($this->client->isActive);
		$form->addBool('isTest', 'multihubDropShip.client.isTest')
			->setDefaultValue($this->client->isTest);
		$form->addBool('addCanAddToCartProds', 'multihubDropShip.client.addCanAddToCartProds')
			->setDescription('multihubDropShip.client.addCanAddToCartProdsDescription')
			->setDefaultValue($this->client->addCanAddToCartProds);
		$form->addText('apiKey', 'multihubDropShip.client.apiKey')
			->setDefaultValue($this->client->apiKey)
			->setNullable();
		$form->addText('secretToken', 'multihubDropShip.client.secretToken')
			->setDefaultValue($this->client->secretToken)
			->setNullable();
		$form->addSelect('sellerIdAllegro', 'multihubDropShip.client.sellerAllegro', $this->sellers->getOptionsForSelect())
			->setDefaultValue($this->client->seller?->getId());
		$form->addSelect('sellerIdKaufland', 'multihubDropShip.client.sellerKaufland', $this->sellers->getOptionsForSelect())
			->setDefaultValue($this->client->sellerKaufland?->getId());
		$form->addSubmit('submit', 'default.save');

		$form->onSuccess[] = $this->formSuccess(...);

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values): bool
	{
		try {
			$this->client->isActive             = (int) $values->isActive;
			$this->client->isTest               = (int) $values->isTest;
			$this->client->apiKey               = $values->apiKey;
			$this->client->secretToken          = $values->secretToken;
			$this->client->addCanAddToCartProds = (int) $values->addCanAddToCartProds;

			/** @var Seller $seller */
			$seller = $this->em->getReference(Seller::class, $values->sellerIdAllegro);

			$this->client->seller = $seller;

			/** @var Seller $seller */
			$seller = $this->em->getReference(Seller::class, $values->sellerIdKaufland);

			$this->client->sellerKaufland = $seller;

			$this->em->persist($this->client);
			$this->em->flush();

			$this->presenter->flashMessageSuccess('default.saved');
			$this->presenter->redrawControl('flashes');

			return true;
		} catch (Exception) {
			$this->presenter->flashMessageDanger('default.error');
			$this->presenter->redrawControl('flashes');
		}

		return false;
	}
}
