<?php declare(strict_types = 1);

namespace MultihubDropShip\AdminModule\Presenters;

use Exception;
use MultihubDropShip\AdminModule\Components\Categories\AllowedCategoriesForm;
use MultihubDropShip\AdminModule\Components\Categories\IAllowedCategoriesFormFactory;
use MultihubDropShip\AdminModule\Components\Clients\ClientForm;
use MultihubDropShip\AdminModule\Components\Clients\IClientFormFactory;
use MultihubDropShip\Model\Clients;
use MultihubDropShip\Model\Entities\Client;
use MultihubDropShip\Model\Sync\SyncProducts;
use Nette\Application\UI\Multiplier;
use Override;

class DefaultPresenter extends BasePresenter
{
	public function __construct(
		protected Clients      $clients,
		protected SyncProducts $syncProducts,
	)
	{
		parent::__construct();
	}

	#[Override]
	protected function startup(): void
	{
		parent::startup();
		$this->setHeader('multihubDropShip.menu.dropShip', 'fas fa-map-signs');
	}

	/*******************************************************************************************************************
	 * ======================== Handle
	 */

	/*******************************************************************************************************************
	 * ======================== Action
	 */

	public function actionDefault(): void
	{
	}

	/*******************************************************************************************************************
	 * ======================== Action
	 */

	public function renderDefault(): void
	{
		$this->template->clients = $this->em->getRepository(Client::class)->findAll();
	}

	public function actionUpdateProducts(int $clientId): void
	{
		$this->syncProducts->updateAll($clientId);
	}

	/*******************************************************************************************************************
	 * ======================== Component
	 */

	protected function createComponentClientForm(IClientFormFactory $factory): Multiplier
	{
		return new Multiplier(function(string $id) use ($factory): ClientForm {
			/** @var Client|null $client */
			$client = $this->em->getRepository(Client::class)->find($id);

			if (!$client) {
				throw new Exception('Client not found');
			}

			return $factory->create($client);
		});
	}

	protected function createComponentAllowedCategoriesForm(IAllowedCategoriesFormFactory $factory): Multiplier
	{
		return new Multiplier(function(string $id) use ($factory): AllowedCategoriesForm {
			/** @var Client|null $client */
			$client = $this->em->getRepository(Client::class)->find($id);

			if (!$client) {
				throw new Exception('Client not found');
			}

			return $factory->create($client);
		});
	}
}
