<?php declare(strict_types = 1);

namespace MultihubDropShip\Console;

use Core\Model\Event\Event;
use Core\Model\Event\EventDispatcher;
use Doctrine;
use Exception;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

#[AsCommand(name: 'multihub-drop-ship:check-completed')]
class CheckCompleted extends Command
{
	public function __construct(
		protected EventDispatcher $eventDispatcher,
	)
	{
		parent::__construct();
	}

	protected function configure(): void
	{
		$this->setName('multihub-drop-ship:check-completed')
			->setDescription('Check orders');
	}

	protected function execute(
		InputInterface  $input,
		OutputInterface $output,
	): int
	{
		$output->writeln('<fg=white;bg=#007bff>Multihub - Check completed</>');
		try {
			$this->eventDispatcher->dispatch(new Event(), 'MultihubDropShip.orders.checkCompleted');

			$output->writeLn('<info>[OK] - orders checked</info>');
		} catch (Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}
}
