<?php declare(strict_types = 1);

namespace MultihubDropShip\Console;

use Core\Model\Entities\EntityManagerDecorator;
use MultihubDropShip\Model\Api\AccountApi;
use MultihubDropShip\Model\CacheService;
use MultihubDropShip\Model\Clients;
use Nette\Utils\Json;
use Override;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

#[AsCommand(name: 'multihub-drop-ship:rating-download')]
class RatingDownload extends Command
{
	public function __construct(
		protected CacheService           $cacheService,
		protected EntityManagerDecorator $em,
		protected AccountApi             $accountApi,
		protected Clients                $clients,
	)
	{
		parent::__construct();
	}

	#[Override]
	protected function configure(): void
	{
		$this->setName('multihub-drop-ship:rating-download');
	}

	#[Override]
	protected function execute(
		InputInterface  $input,
		OutputInterface $output,
	): int
	{
		$output->writeln('Multihub rating download');

		$conn = $this->em->getConnection();
		try {
			foreach ($this->clients->getClients() as $client) {
				$data = $this->accountApi->getAccount($client);

				if (isset($data['rating'])) {
					if (isset($data['rating']['allegro'])) {
						$conn->update('multihub_drop_ship__client', [
							'allegro_rating' => Json::encode($data['rating']['allegro']),
						], [
							'id' => $client->getId(),
						]);

						$this->cacheService->clearRating($client->getId());
					}
				}
			}

			$output->writeLn('<info>[OK] - downloaded</info>');

			return 0;
		} catch (\Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}

}
