<?php declare(strict_types = 1);

namespace MultihubDropShip\Model\Dao;

class Category
{
	public int $level = 0;

	public ?string $parentId       = null;
	public ?string $url            = null;
	public ?string $image          = null;
	public ?string $type           = null;
	public ?int    $activeProducts = null;

	/** @var array<int, array<string, string>> */
	public array $images = [];

	/** @var CategoryText[] */
	public array $texts = [];

	public function __construct(
		public string $remoteId,
		public string $name,
	)
	{
	}
}
