<?php declare(strict_types = 1);

namespace MultihubDropShip\Model\Entities;

use Core\Model\Entities\TIdUnsigned;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Entities\Seller;

#[ORM\Table(name: 'multihub_drop_ship__client')]
#[ORM\Entity]
class Client
{
	use TIdUnsigned;

	#[ORM\Column(type: Types::STRING, length: 255, unique: true, nullable: false)]
	public string $name;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $apiKey = null;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $secretToken = null;

	#[ORM\Column(type: Types::SMALLINT, length: 1, nullable: false, options: ['default' => 0, 'unsigned' => true])]
	public int $isTest = 0;

	#[ORM\Column(type: Types::SMALLINT, length: 1, nullable: false, options: ['default' => 0, 'unsigned' => true])]
	public int $isActive = 0;

	#[ORM\Column(type: Types::SMALLINT, length: 1, nullable: false, options: ['default' => 0, 'unsigned' => true])]
	public int $sendAll = 0;

	#[ORM\Column(type: Types::SMALLINT, length: 1, nullable: false, options: ['default' => 0, 'unsigned' => true])]
	public int $addCanAddToCartProds = 0;

	/** @var Collection<int, AllowedCategory> */
	#[ORM\OneToMany(targetEntity: AllowedCategory::class, mappedBy: 'client', indexBy: 'category_id')]
	public Collection $allowedCategories;

	/**
	 * Allegro
	 */
	#[ORM\JoinColumn(referencedColumnName: 'id', onDelete: 'SET NULL')]
	#[ORM\ManyToOne(targetEntity: Seller::class)]
	public ?Seller $seller = null;

	/**
	 * Kaufland
	 */
	#[ORM\JoinColumn(referencedColumnName: 'id', onDelete: 'SET NULL')]
	#[ORM\ManyToOne(targetEntity: Seller::class)]
	public ?Seller $sellerKaufland = null;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: false, options: ['default' => ''])]
	public string $imageBaseUrl = '';

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $siteIdent = null;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $lang = null;

	#[ORM\Column(type: Types::JSON, nullable: true)]
	public ?array $allegroRating = null;

	public function __construct(string $name)
	{
		$this->name              = $name;
		$this->allowedCategories = new ArrayCollection();
	}
}
