<?php declare(strict_types = 1);

namespace MultihubDropShip\Model\Subscribers;

use Core\Model\Entities\EntityManagerDecorator;
use Doctrine\Common\EventSubscriber;
use Doctrine\ORM\Event\OnFlushEventArgs;
use Doctrine\Persistence\Event\LifecycleEventArgs;
use EshopCatalog\Model\Entities\Category;
use Exception;
use MultihubDropShip\Model\Api\CategoriesApi;
use MultihubDropShip\Model\Clients;
use MultihubDropShip\Model\EshopCategories;
use Override;

class CategorySubscriber implements EventSubscriber
{
	public static array $update = [];

	public function __construct(
		protected CategoriesApi          $categoriesApi,
		protected Clients                $clients,
		protected EshopCategories        $eshopCategories,
		protected EntityManagerDecorator $em,
	)
	{
	}

	#[Override]
	public function getSubscribedEvents(): array
	{
		return [
			'onFlush',
			'postUpdate',
		];
	}

	public function onFlush(OnFlushEventArgs $args): void
	{
		$uow = $this->em->getUnitOfWork();

		foreach ($uow->getScheduledEntityUpdates() as $object) {
			if ($object instanceof Category) {
				$changeSet = $uow->getEntityChangeSet($object);
				unset($changeSet['modified'], $changeSet['categoryTexts']);

				$changeSetCount = count($changeSet);
				if ($changeSetCount === 0) {
					continue;
				}

				self::$update[] = $object->getId();
			}
		}

		foreach ($uow->getScheduledEntityDeletions() as $object) {
			if ($object instanceof Category === false) {
				continue;
			}

			foreach ($this->clients->getClients() as $client) {
				try {
					$this->categoriesApi->deleteCategory($client, (string) $object->getId());
				} catch (Exception) {
				}
			}
		}
	}

	public function postUpdate(LifecycleEventArgs $event): void
	{
		try {
			$this->checkCategory($event->getObject());
		} catch (Exception) {
		}
	}

	protected function checkCategory(object $entity): void
	{
		if ($entity instanceof Category === false) {
			return;
		}

		if (isset($_REQUEST['_do']) && $_REQUEST['_do'] === 'categoryForm-form-submit') {
			return;
		}

		self::$update[] = $entity->getId();
	}
}
