<?php declare(strict_types = 1);

namespace MultihubDropShip\AdminModule\Model\Subscribers;

use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\Event\FormSuccessEvent;
use Core\Model\Helpers\Arrays;
use DynamicModule\AdminModule\Model\Events\MemberEvent;
use EshopCatalog\AdminModule\Components\Categories\CategoryForm;
use EshopCatalog\Model\Entities\Category;
use MultihubDropShip\Model\Clients;
use MultihubDropShip\Model\Dao\Client;
use MultihubDropShip\Model\Subscribers\CategorySubscriber;
use Nette\Http\Request;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class CategoryFormSubscriber implements EventSubscriberInterface
{
	protected EntityManagerDecorator $em;
	protected Clients                $clients;
	protected Request                $httpRequest;

	protected static array $isInMultihub = [];

	public function __construct(
		EntityManagerDecorator $em,
		Clients                $clients,
		Request                $request
	)
	{
		$this->em          = $em;
		$this->clients     = $clients;
		$this->httpRequest = $request;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			CategoryForm::class . '::formSuccessAfterSave' => ['formSuccessAfterSave', -200],
			'dynamicModule.admin.dynamic.memberChanged'    => 'memberChanged',
			'dynamicModule.admin.dynamic.memberRemoved'    => 'memberChanged',
		];
	}

	protected function checkMultihub(Client $client, int $id): bool
	{
		if (!isset(self::$isInMultihub[$client->getId()][$id])) {
			if (!array_key_exists($client->getId(), self::$isInMultihub)) {
				self::$isInMultihub[$client->getId()] = [];
			}

			if ($client->sendAll) {
				self::$isInMultihub[$client->getId()][$id] = true;
			} else {
				self::$isInMultihub[$client->getId()][$id] = Arrays::contains($client->allowedCategoriesIds, $id);
			}
		}

		return self::$isInMultihub[$client->getId()][$id] ?? false;
	}

	public function formSuccessAfterSave(FormSuccessEvent $event): void
	{
		// TODO pokud se odebere z kategorie ale existuje na hubu, tak se nic neodesle
		/** @var Category $category */
		$category = $event->custom['entity'];

		if ($event->form) {
			foreach ($this->clients->getClients() as $client) {
				if (!$this->checkMultihub($client, $event->form->getCustomData('categoryId'))) {
					continue;
				}

				CategorySubscriber::$update[] = $category->getId();
			}
		}
	}

	/** @param MemberEvent $event */
	public function memberChanged($event): void
	{
		CategorySubscriber::$update[] = 'V_' . $event->member->getId();
	}
}
