<?php declare(strict_types = 1);

namespace MultihubDropShip\AdminModule\Model\Subscribers;

use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\Event\CreateFormEvent;
use Core\Model\Event\FormSuccessEvent;
use Core\Model\Event\SetFormDataEvent;
use EshopCatalog\AdminModule\Components\Products\ProductForm;
use EshopCatalog\Model\Entities\Product;
use MultihubDropShip\Model\Clients;
use MultihubDropShip\Model\Dao\Client;
use MultihubDropShip\Model\EshopProducts;
use MultihubDropShip\Model\Subscribers\ProductSubscriber;
use Nette\Http\Request;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Tracy\Debugger;

class ProductFormSubscriber implements EventSubscriberInterface
{
	protected EntityManagerDecorator $em;
	protected Clients                $clients;
	protected Request                $httpRequest;
	protected EshopProducts          $eshopProducts;

	protected static array $isInMultihub = [];

	public function __construct(
		EntityManagerDecorator $em,
		Clients                $clients,
		Request                $request,
		EshopProducts          $eshopProducts
	)
	{
		$this->em            = $em;
		$this->clients       = $clients;
		$this->httpRequest   = $request;
		$this->eshopProducts = $eshopProducts;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			ProductForm::class . '::createForm'           => 'createForm',
			ProductForm::class . '::formSuccessAfterSave' => ['formSuccessAfterSave', -200],
			ProductForm::class . '::setProduct'           => 'setProduct',
		];
	}

	protected function checkMultihub(Client $client): bool
	{
		$urlPathArray = explode('/', $this->httpRequest->getUrl()->getPath());
		$id           = (int) end($urlPathArray);

		if ($id) {
			if (!array_key_exists($client->getId(), self::$isInMultihub)) {
				self::$isInMultihub[$client->getId()] = [];
			}

			self::$isInMultihub[$client->getId()][$id] = $this->eshopProducts->isProductAllowed($id, $client);
		}

		return self::$isInMultihub[$client->getId()][$id] ?? false;
	}

	public function createForm(CreateFormEvent $event): void
	{
	}

	public function formSuccessAfterSave(FormSuccessEvent $event): void
	{
		// TODO pokud se odebere z kategorie ale existuje na hubu, tak se nic neodesle
		/** @var Product $product */
		$product = $event->custom['entity'];
		$values  = $event->values;

		foreach ($this->clients->getClients() as $client) {
			if (!$this->checkMultihub($client)) {
				continue;
			}

			ProductSubscriber::$update[] = $product->getId();
		}
	}

	public function setProduct(SetFormDataEvent $event): void
	{
	}

}
