<?php declare(strict_types = 1);

namespace MultihubDropShip\Console;

use Doctrine;
use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use MultihubDropShip\Model\Sync\SyncProducts;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;
use Tracy\Debugger;

class Update extends AbstractCommand
{
	protected SyncProducts $syncProducts;

	public function __construct(
		SyncProducts $syncProducts,
		?string      $name = null
	)
	{
		parent::__construct($name);
		$this->syncProducts = $syncProducts;
	}

	protected function configure(): void
	{
		$this->setName('multihub-drop-ship:update-all')
			->addOption('clientId', null, InputOption::VALUE_REQUIRED)
			->addOption('service', null, InputOption::VALUE_OPTIONAL)
			->setDescription('Update all products');
	}

	protected function executeSchemaCommand(InputInterface $input, OutputInterface $output, Doctrine\ORM\Tools\SchemaTool $schemaTool, array $metadatas, SymfonyStyle $ui): int
	{
		$output->writeln('Multihub DropShip - update all products');

		try {
			Debugger::dispatch();
			ini_set('memory_limit', '3G');

			if ($input->getOption('service') === 'allegro') {
				$this->syncProducts->sendAllTo((int) $input->getOption('clientId'), 'allegro');
			} else if ($input->getOption('service') === 'kaufland') {
				$this->syncProducts->sendAllTo((int) $input->getOption('clientId'), 'kaufland');
			} else {
				$this->syncProducts->updateAll((int) $input->getOption('clientId'));
			}

			$output->writeLn('<info>[OK] - products updated</info>');

			return 0;
		} catch (\Exception $e) {
			Debugger::log($e, 'multihub-update-error');
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}
}
