<?php declare(strict_types = 1);

namespace MultihubDropShip\Model\Api;

use MultihubDropShip\Model\Dao\Client;
use MultihubDropShip\Model\Dao\Product;
use Nette\Utils\Json;

class ProductsApi extends BaseApi
{
	public function getProducts(Client $client): array
	{
		return $this->sendRequest($client, 'GET', '/api/v1/product')['data'] ?? [];
	}

	public function updateProduct(Client $client, Product $product): ?array
	{
		return $this->sendRequest($client, 'POST', '/api/' . $client->updateProductV . '/product', [], Json::decode(Json::encode($product), Json::FORCE_ARRAY));
	}

	public function deleteProduct(Client $client, string $id): ?array
	{
		return $this->sendRequest($client, 'DELETE', '/api/' . $client->updateProductV . '/product/' . $id);
	}

	public function sendAllTo(Client $client, string $service): void
	{
		$this->sendRequest($client, 'POST', '/api/v1/product/send-to', [], ['service' => $service]);
	}

	public function sendTo(Client $client, string $productId, string $service): void
	{
		$this->sendRequest($client, 'POST', '/api/v1/product/send-to', [], [
			'remoteId' => $productId,
			'service'  => $service,
		]);
	}

	public function updateStatus(Client $client, string $productId, string $state): bool
	{
		return $this->sendRequest($client, 'PUT', '/api/' . $client->updateProductV . '/product/status', [], [
			'remoteId' => $productId,
			'state'    => $state,
		])['accepted'] ?? false;
	}
}
