<?php declare(strict_types = 1);

namespace MultihubDropShip\Model\Dao;

class Category
{
	public string $remoteId;
	public string $name;
	public int    $level = 0;

	public ?string $parentId       = null;
	public ?string $url            = null;
	public ?string $image          = null;
	public ?string $type           = null;
	public ?int    $activeProducts = null;

	/** @var CategoryText[] */
	public array $texts = [];

	/** @var array<int, array<string, string>> */
	public array $images = [];

	public function __construct(string $remoteId, string $name)
	{
		$this->remoteId = $remoteId;
		$this->name     = $name;
	}
}
