<?php declare(strict_types = 1);

namespace MultihubDropShip\Model\Dao;

class Client
{
	protected int     $id;
	protected string  $name;
	protected string  $apiKey;
	protected ?string $secretToken          = null;
	public string     $imageBaseUrl;
	public string     $endPoint;
	public bool       $isTest               = false;
	public bool       $sendAll              = false;
	public bool       $addCanAddToCartProds = false;
	public array      $allowedCategoriesIds = [];
	public string     $lang                 = 'cs';
	public ?int       $sellerId             = null;
	public ?int       $sellerIdKaufland     = null;
	public ?string    $siteIdent            = null;
	public string     $updateProductV       = 'v2';
	public string     $updateCategoryV      = 'v2';

	public function __construct(
		int     $id,
		string  $name,
		string  $apiKey,
		?string $secretToken,
		string  $imageBaseUrl,
		string  $endPoint
	)
	{
		$this->id           = $id;
		$this->name         = $name;
		$this->apiKey       = $apiKey;
		$this->secretToken  = $secretToken;
		$this->imageBaseUrl = $imageBaseUrl;
		$this->endPoint     = $endPoint;
	}

	public function getId(): int { return $this->id; }

	public function getName(): string { return $this->name; }

	public function getApiKey(): string { return $this->apiKey; }

	public function getSecretToken(): ?string { return $this->secretToken; }

	public function getEndPoint(): string { return $this->endPoint; }
}
