<?php declare(strict_types = 1);

namespace MultihubDropShip\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Entities\Category;

/**
 * @ORM\Entity
 * @ORM\Table(name="multihub_drop_ship__client_allowed_category")
 */
class AllowedCategory
{
	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Client", inversedBy="allowedCategories")
	 * @ORM\JoinColumn(referencedColumnName="id", onDelete="CASCADE")
	 */
	protected Client $client;

	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="EshopCatalog\Model\Entities\Category")
	 * @ORM\JoinColumn(referencedColumnName="id", onDelete="CASCADE")
	 */
	protected Category $category;

	public function __construct(Client $client, Category $category)
	{
		$this->client   = $client;
		$this->category = $category;
	}
}
