<?php declare(strict_types = 1);

namespace MultihubDropShip\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\DateTime;

/**
 * @ORM\Entity
 * @ORM\Table(name="multihub_drop_ship__category_update_list")
 */
class CategoryUpdateList
{
	/**
	 * @ORM\Id
	 * @ORM\Column(type="string", options={"unsigned": true}, nullable=false)
	 */
	public string $categoryId;

	/**
	 * @ORM\Column(type="datetime", nullable=false, options={"default": "CURRENT_TIMESTAMP"})
	 */
	public ?\DateTimeInterface $created;

	public function __construct(string $categoryId)
	{
		$this->categoryId = $categoryId;
		$this->created    = new DateTime();
	}
}
