<?php declare(strict_types = 1);

namespace MultihubDropShip\Model\Entities;

use DateTimeInterface;
use Doctrine\ORM\Mapping as ORM;
use EshopOrders\Model\Entities\Order;
use Nette\Utils\DateTime;

/**
 * @ORM\Entity
 * @ORM\Table(name="multihub_drop_ship__order", indexes={
 *     @ORM\Index(name="dropShipId", columns={"drop_ship_id"}),
 * })
 */
class DropShipOrder
{
	public const StatusNew        = 'new';
	public const StatusAccepted   = 'accepted';
	public const StatusProcessing = 'processing';
	public const StatusPacking    = 'packing';
	public const StatusShipped    = 'shipped';
	public const StatusSent       = 'sent';
	public const StatusCompleted  = 'completed';
	public const StatusCancelled  = 'cancelled';

	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="EshopOrders\Model\Entities\Order")
	 * @ORM\JoinColumn(referencedColumnName="id", onDelete="CASCADE")
	 */
	public Order $order;

	/**
	 * @ORM\ManyToOne(targetEntity="Client")
	 * @ORM\JoinColumn(referencedColumnName="id", onDelete="SET NULL")
	 */
	public Client $client;

	/**
	 * @ORM\Column(type="string", nullable=false)
	 */
	public string $dropShipId;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $marketplace = null;

	/**
	 * @ORM\Column(type="string", nullable=false, options={"default": "new"})
	 */
	public string $lastStatus = self::StatusNew;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	public ?string $trackingNumber = null;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	public ?string $trackingUrl = null;

	/**
	 * @ORM\Column(type="datetime", nullable=true)
	 */
	protected ?DateTimeInterface $exported = null;

	public function __construct(Client $client, Order $order, string $dropShipId)
	{
		$this->client     = $client;
		$this->order      = $order;
		$this->dropShipId = $dropShipId;
	}

	public function setExported(): void
	{
		$this->lastStatus = self::StatusShipped;
		$this->exported   = new DateTime();
	}

	public function getExported(): ?DateTimeInterface { return $this->exported; }
}
