<?php declare(strict_types = 1);

namespace MultihubDropShip\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\DateTime;

/**
 * @ORM\Entity
 * @ORM\Table(name="multihub_drop_ship__product_update_list")
 */
class ProductUpdateList
{
	/**
	 * @ORM\Id
	 * @ORM\Column(type="integer", options={"unsigned": true}, nullable=false)
	 */
	public int $productId;

	/**
	 * @ORM\Column(type="datetime", nullable=false, options={"default": "CURRENT_TIMESTAMP"})
	 */
	public ?\DateTimeInterface $created;

	public function __construct(int $productId)
	{
		$this->productId = $productId;
		$this->created   = new DateTime();
	}
}
