<?php declare(strict_types = 1);

namespace MultihubDropShip\Model\Event;

use MultihubDropShip\Model\Dao\Client;
use MultihubDropShip\Model\Dao\Product;
use Symfony\Contracts\EventDispatcher\Event;

class ProductBuilderEvent extends Event
{
	public Client $client;

	/** @var Product[] */
	public array $products;

	/** @var \EshopCatalog\FrontModule\Model\Dao\Product[] */
	public array $eshopProducts;

	public function __construct(Client $client, array $products, array $eshopProducts)
	{
		$this->client        = $client;
		$this->products      = $products;
		$this->eshopProducts = $eshopProducts;
	}
}
