<?php declare(strict_types = 1);

namespace MultihubDropShip\Model\Subscribers;

use Contributte\Events\Extra\Event\Application\ResponseEvent;
use Contributte\Events\Extra\Event\Application\ShutdownEvent;
use Core\Model\Application\AppState;
use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\Event\ApiShutdownEvent;
use Core\Model\Event\Event;
use DateTime;
use MultihubDropShip\Model\Clients;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class ApplicationSubscriber implements EventSubscriberInterface
{
	protected EntityManagerDecorator $em;
	protected Clients                $clients;

	public function __construct(
		EntityManagerDecorator $em,
		Clients                $clients
	)
	{
		$this->em      = $em;
		$this->clients = $clients;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			ShutdownEvent::class                => 'shutdown',
			ResponseEvent::class                => 'response',
			ApiShutdownEvent::class             => 'apiShutdown',
			'cli.eshopCatalog.category.updated' => 'categoryUpdated',
			'cli.dynamicModule.member.updated'  => 'memberUpdated',
		];
	}

	public function shutdown(ShutdownEvent $event): void
	{
		$this->processUpdate();
	}

	public function apiShutdown(ApiShutdownEvent $event): void
	{
		$this->processUpdate();
	}

	public function categoryUpdated(Event $data): void
	{
		$categories = $data->data['categories'] ?? [];
		if (!empty($categories)) {
			$activeClients = $this->clients->getClients();

			if (!empty($activeClients)) {
				foreach (array_unique($categories) as $id) {
					try {
						$this->em->getConnection()->executeQuery("INSERT IGNORE INTO multihub_drop_ship__category_update_list (`category_id`, `created`) VALUES (:id, :created)", [
							'id'      => (string) $id,
							'created' => (new DateTime())->format('Y-m-d H:i:s'),
						]);
					} catch (\Exception $e) {
					}
				}
			}
		}
	}

	public function memberUpdated(Event $data): void
	{
		$members = $data->data['members'] ?? [];
		if (!empty($members)) {
			$activeClients = $this->clients->getClients();

			if (!empty($activeClients)) {
				foreach (array_unique($members) as $id) {
					try {
						$this->em->getConnection()->executeQuery("INSERT IGNORE INTO multihub_drop_ship__category_update_list (`category_id`, `created`) VALUES (:id, :created)", [
							'id'      => 'V_' . $id,
							'created' => (new DateTime())->format('Y-m-d H:i:s'),
						]);
					} catch (\Exception $e) {
					}
				}
			}
		}
	}

	protected function processUpdate(): void
	{
		if (!empty(ProductSubscriber::$update)) {
			$activeClients = $this->clients->getClients();

			if (!empty($activeClients)) {
				foreach (array_unique(ProductSubscriber::$update) as $id) {
					try {
						$this->em->getConnection()->executeQuery("INSERT IGNORE INTO multihub_drop_ship__product_update_list (`product_id`, `created`) VALUES (:id, :created)", [
							'id'      => $id,
							'created' => (new DateTime())->format('Y-m-d H:i:s'),
						]);
					} catch (\Exception $e) {
					}
				}
			}
		}

		$appStateCategories = AppState::getUpdatedEntitiesIds('eshopCatalog.category');
		if ($appStateCategories) {
			CategorySubscriber::$update = array_merge(CategorySubscriber::$update, $appStateCategories);
		}

		$appStateMembers = AppState::getUpdatedEntitiesIds('dynamicModule.member');
		if ($appStateMembers) {
			CategorySubscriber::$update = array_merge(CategorySubscriber::$update, $appStateMembers);
		}

		if (!empty(CategorySubscriber::$update)) {
			$activeClients = $this->clients->getClients();

			if (!empty($activeClients)) {
				foreach (array_unique(CategorySubscriber::$update) as $id) {
					try {
						$this->em->getConnection()->executeQuery("INSERT IGNORE INTO multihub_drop_ship__category_update_list (`category_id`, `created`) VALUES (:id, :created)", [
							'id'      => (string) $id,
							'created' => (new DateTime())->format('Y-m-d H:i:s'),
						]);
					} catch (\Exception $e) {
					}
				}
			}
		}
	}

	public function response(ResponseEvent $event): void
	{
	}
}
