<?php declare(strict_types = 1);

namespace MultihubDropShip\Model\Sync;

use Core\Model\Sites;
use EshopCatalog\AdminModule\Model\Categories;
use MultihubDropShip\Model\Api\CategoriesApi;
use MultihubDropShip\Model\CategoryBuilder;
use MultihubDropShip\Model\Clients;
use MultihubDropShip\Model\EshopCategories;

class SyncCategories
{
	protected Clients         $clients;
	protected CategoriesApi   $categoriesApi;
	protected Categories      $categories;
	protected EshopCategories $eshopCategories;
	protected CategoryBuilder $categoryBuilder;

	public function __construct(
		Clients         $clients,
		CategoriesApi   $categoriesApi,
		Categories      $categories,
		EshopCategories $eshopCategories,
		CategoryBuilder $categoryBuilder
	)
	{
		$this->clients         = $clients;
		$this->categoriesApi   = $categoriesApi;
		$this->categories      = $categories;
		$this->eshopCategories = $eshopCategories;
		$this->categoryBuilder = $categoryBuilder;
	}

	public function updateAll(int $clientId): void
	{
		$client = $this->clients->getClient($clientId);
		if (!$client) {
			return;
		}

		Sites::$currentIdentOverride = $client->siteIdent;
		Sites::$currentLangOverride  = $client->lang;

		$categoriesIds = $this->eshopCategories->getCategories($client);

		if (empty($categoriesIds)) {
			return;
		}

		$hubCategories = $this->categoriesApi->getCategories($client);

		foreach (array_diff_key($hubCategories, array_flip($categoriesIds)) as $id => $hubCategory) {
			$this->categoriesApi->deleteCategory($client, (string) $id);
		}

		$hubCategories = null;

		foreach ($this->categoryBuilder->buildCategories($client, $categoriesIds) as $category) {
			$this->categoriesApi->updateCategory($client, $category);
		}
	}
}
